using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmRecordSupplyUsage
	/// </summary>
	public class FrmRecordSupplyUsage : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		private BOL.Supply _selectedSupply = new BOL.Supply(System.Guid.NewGuid());
		private bool _isLoading = false;
		private bool _limitInvoice = false;

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpInventory;
		private System.Windows.Forms.Panel pnlContainer;
		private System.Windows.Forms.Panel pnlLot;
		private System.Windows.Forms.RadioButton rdoUnsatisfactory;
		private System.Windows.Forms.RadioButton rdoSatisfactory;
		private System.Windows.Forms.Label lblInspection;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnUpdate;
		private System.Windows.Forms.DateTimePicker dtpChangedTime;
		private System.Windows.Forms.Label lblDateTime;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.Label lblComments;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReason;
		private System.Windows.Forms.Label lblReason;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private System.Windows.Forms.TextBox txtSupplyType;
		private System.Windows.Forms.Label lblReagentType;
		private System.Windows.Forms.Panel pnlReagentHeader;
		private System.Windows.Forms.Label lblReagentHeader;
		private System.Windows.Forms.PictureBox picFlask;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlTreeView;
		private System.Windows.Forms.Button btnSearch;
		private System.Windows.Forms.TextBox txtLotSearch;
		private System.Windows.Forms.TreeView tvInventory;
		private System.Windows.Forms.Panel pnlTreeViewHeader;
		private System.Windows.Forms.Label lblInventory;
		private System.Windows.Forms.PictureBox picInventory;
		private System.Windows.Forms.TextBox txtSupplyName;
		private System.Windows.Forms.Label lblSupplyName;
		private System.Windows.Forms.GroupBox grpImage1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.CheckBox cbShowExpired;
		private System.Windows.Forms.Panel pnlSupplyType;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updQuantityAvailable;
		private System.Windows.Forms.Label lblQuantityAvailable;
		private System.Windows.Forms.Panel pnlSupplyName;
		private System.Windows.Forms.Label lblLotSearch;
		private System.Windows.Forms.ImageList imageList1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor -- when being sent from FrmLogInSupplies
		/// </summary>
		public FrmRecordSupplyUsage(System.Guid supplyGuid)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC081MaintainBloodBankSupplies;

			//Lock the unit
			if (!this.SetLocks(supplyGuid))
			{
				this.DialogResult = DialogResult.Abort;
				return;
			}

			this._isLoading = true;

			this._selectedSupply = new BOL.Supply(supplyGuid);
			
			//This limits the tree-views contents to the incomign invoice number
			this._limitInvoice = true;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.SetLotNumberNode();

			this._isLoading = false;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmRecordSupplyUsage()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC081MaintainBloodBankSupplies;

			this._isLoading = true;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.SetControlData(true,0);
			this.SetControlState(false,0);

			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmRecordSupplyUsage));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpInventory = new System.Windows.Forms.GroupBox();
			this.pnlContainer = new System.Windows.Forms.Panel();
			this.pnlSupplyType = new System.Windows.Forms.Panel();
			this.pnlLot = new System.Windows.Forms.Panel();
			this.rdoUnsatisfactory = new System.Windows.Forms.RadioButton();
			this.rdoSatisfactory = new System.Windows.Forms.RadioButton();
			this.lblInspection = new System.Windows.Forms.Label();
			this.btnUpdate = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.dtpChangedTime = new System.Windows.Forms.DateTimePicker();
			this.lblDateTime = new System.Windows.Forms.Label();
			this.txtComments = new System.Windows.Forms.TextBox();
			this.lblComments = new System.Windows.Forms.Label();
			this.cmbReason = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblReason = new System.Windows.Forms.Label();
			this.updQuantityAvailable = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblQuantityAvailable = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.pnlSupplyName = new System.Windows.Forms.Panel();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.txtSupplyName = new System.Windows.Forms.TextBox();
			this.lblSupplyName = new System.Windows.Forms.Label();
			this.txtSupplyType = new System.Windows.Forms.TextBox();
			this.lblReagentType = new System.Windows.Forms.Label();
			this.pnlReagentHeader = new System.Windows.Forms.Panel();
			this.lblReagentHeader = new System.Windows.Forms.Label();
			this.picFlask = new System.Windows.Forms.PictureBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlTreeView = new System.Windows.Forms.Panel();
			this.cbShowExpired = new System.Windows.Forms.CheckBox();
			this.btnPrint = new System.Windows.Forms.Button();
			this.btnSearch = new System.Windows.Forms.Button();
			this.txtLotSearch = new System.Windows.Forms.TextBox();
			this.lblLotSearch = new System.Windows.Forms.Label();
			this.tvInventory = new System.Windows.Forms.TreeView();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.pnlTreeViewHeader = new System.Windows.Forms.Panel();
			this.lblInventory = new System.Windows.Forms.Label();
			this.picInventory = new System.Windows.Forms.PictureBox();
			this.grpImage1 = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.grpInventory.SuspendLayout();
			this.pnlContainer.SuspendLayout();
			this.pnlSupplyType.SuspendLayout();
			this.pnlLot.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updQuantityAvailable)).BeginInit();
			this.pnlSupplyName.SuspendLayout();
			this.pnlReagentHeader.SuspendLayout();
			this.pnlTreeView.SuspendLayout();
			this.pnlTreeViewHeader.SuspendLayout();
			this.grpImage1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.TabIndex = 2;
			this.vbecsLogo1.Title = "Update Supplies";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(564, 448);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 20;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpInventory
			// 
			this.grpInventory.AccessibleDescription = "Supply inventory";
			this.grpInventory.AccessibleName = "Supply inventory";
			this.grpInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInventory.Controls.Add(this.pnlContainer);
			this.grpInventory.Location = new System.Drawing.Point(56, 32);
			this.grpInventory.Name = "grpInventory";
			this.grpInventory.Size = new System.Drawing.Size(584, 412);
			this.grpInventory.TabIndex = 0;
			this.grpInventory.TabStop = false;
			// 
			// pnlContainer
			// 
			this.pnlContainer.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlContainer.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlContainer.Controls.Add(this.pnlSupplyType);
			this.pnlContainer.Controls.Add(this.splitter1);
			this.pnlContainer.Controls.Add(this.pnlTreeView);
			this.pnlContainer.Location = new System.Drawing.Point(8, 12);
			this.pnlContainer.Name = "pnlContainer";
			this.pnlContainer.Size = new System.Drawing.Size(568, 392);
			this.pnlContainer.TabIndex = 0;
			// 
			// pnlSupplyType
			// 
			this.pnlSupplyType.Controls.Add(this.pnlLot);
			this.pnlSupplyType.Controls.Add(this.pnlSupplyName);
			this.pnlSupplyType.Controls.Add(this.txtSupplyType);
			this.pnlSupplyType.Controls.Add(this.lblReagentType);
			this.pnlSupplyType.Controls.Add(this.pnlReagentHeader);
			this.pnlSupplyType.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlSupplyType.Location = new System.Drawing.Point(175, 0);
			this.pnlSupplyType.Name = "pnlSupplyType";
			this.pnlSupplyType.Size = new System.Drawing.Size(391, 390);
			this.pnlSupplyType.TabIndex = 5;
			// 
			// pnlLot
			// 
			this.pnlLot.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlLot.Controls.Add(this.rdoUnsatisfactory);
			this.pnlLot.Controls.Add(this.rdoSatisfactory);
			this.pnlLot.Controls.Add(this.lblInspection);
			this.pnlLot.Controls.Add(this.btnUpdate);
			this.pnlLot.Controls.Add(this.dtpChangedTime);
			this.pnlLot.Controls.Add(this.lblDateTime);
			this.pnlLot.Controls.Add(this.txtComments);
			this.pnlLot.Controls.Add(this.lblComments);
			this.pnlLot.Controls.Add(this.cmbReason);
			this.pnlLot.Controls.Add(this.lblReason);
			this.pnlLot.Controls.Add(this.updQuantityAvailable);
			this.pnlLot.Controls.Add(this.lblQuantityAvailable);
			this.pnlLot.Controls.Add(this.txtExpirationDate);
			this.pnlLot.Controls.Add(this.lblExpirationDate);
			this.pnlLot.Controls.Add(this.txtLotNumber);
			this.pnlLot.Controls.Add(this.lblLotNumber);
			this.pnlLot.Location = new System.Drawing.Point(0, 104);
			this.pnlLot.Name = "pnlLot";
			this.pnlLot.Size = new System.Drawing.Size(390, 286);
			this.pnlLot.TabIndex = 10;
			// 
			// rdoUnsatisfactory
			// 
			this.rdoUnsatisfactory.AccessibleDescription = "unsatisfactory";
			this.rdoUnsatisfactory.AccessibleName = "unsatisfactory";
			this.rdoUnsatisfactory.Enabled = false;
			this.rdoUnsatisfactory.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.rdoUnsatisfactory.Location = new System.Drawing.Point(152, 76);
			this.rdoUnsatisfactory.Name = "rdoUnsatisfactory";
			this.rdoUnsatisfactory.Size = new System.Drawing.Size(104, 20);
			this.rdoUnsatisfactory.TabIndex = 14;
			this.rdoUnsatisfactory.TabStop = true;
			this.rdoUnsatisfactory.Text = "&Unsatisfactory";
			// 
			// rdoSatisfactory
			// 
			this.rdoSatisfactory.AccessibleDescription = "satisfactory";
			this.rdoSatisfactory.AccessibleName = "satisfactory";
			this.rdoSatisfactory.Enabled = false;
			this.rdoSatisfactory.Location = new System.Drawing.Point(152, 52);
			this.rdoSatisfactory.Name = "rdoSatisfactory";
			this.rdoSatisfactory.Size = new System.Drawing.Size(88, 20);
			this.rdoSatisfactory.TabIndex = 13;
			this.rdoSatisfactory.TabStop = true;
			this.rdoSatisfactory.Text = "&Satisfactory";
			// 
			// lblInspection
			// 
			this.lblInspection.Location = new System.Drawing.Point(8, 52);
			this.lblInspection.Name = "lblInspection";
			this.lblInspection.Size = new System.Drawing.Size(140, 20);
			this.lblInspection.TabIndex = 4;
			this.lblInspection.Text = "Inspection";
			this.lblInspection.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnUpdate
			// 
			this.btnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnUpdate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnUpdate.Image = ((System.Drawing.Image)(resources.GetObject("btnUpdate.Image")));
			this.btnUpdate.Location = new System.Drawing.Point(306, 258);
			this.btnUpdate.Name = "btnUpdate";
			this.btnUpdate.Size = new System.Drawing.Size(75, 23);
			this.btnUpdate.TabIndex = 19;
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			// 
			// dtpChangedTime
			// 
			this.dtpChangedTime.AccessibleDescription = "date changed";
			this.dtpChangedTime.AccessibleName = "date changed";
			this.dtpChangedTime.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpChangedTime.Enabled = false;
			this.dtpChangedTime.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpChangedTime.Location = new System.Drawing.Point(152, 124);
			this.dtpChangedTime.Name = "dtpChangedTime";
			this.dtpChangedTime.Size = new System.Drawing.Size(164, 20);
			this.dtpChangedTime.TabIndex = 16;
			this.dtpChangedTime.Value = new System.DateTime(2004, 7, 6, 14, 29, 0, 0);
			this.dtpChangedTime.Enter += new System.EventHandler(this.dtpChangedTime_Enter);
			this.dtpChangedTime.Leave += new System.EventHandler(this.InventoryChangeDateEvent);
			this.dtpChangedTime.ValueChanged += new System.EventHandler(this.InventoryChangeDateEvent);
			// 
			// lblDateTime
			// 
			this.lblDateTime.Location = new System.Drawing.Point(8, 124);
			this.lblDateTime.Name = "lblDateTime";
			this.lblDateTime.Size = new System.Drawing.Size(140, 20);
			this.lblDateTime.TabIndex = 9;
			this.lblDateTime.Text = "Date Changed*";
			this.lblDateTime.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComments
			// 
			this.txtComments.AccessibleDescription = "comments";
			this.txtComments.AccessibleName = "comments";
			this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComments.Enabled = false;
			this.txtComments.Location = new System.Drawing.Point(152, 172);
			this.txtComments.MaxLength = 255;
			this.txtComments.Multiline = true;
			this.txtComments.Name = "txtComments";
			this.txtComments.Size = new System.Drawing.Size(230, 82);
			this.txtComments.TabIndex = 18;
			this.txtComments.Text = "";
			this.txtComments.TextChanged += new System.EventHandler(this.txtComments_Leave);
			this.txtComments.Leave += new System.EventHandler(this.txtComments_Leave);
			// 
			// lblComments
			// 
			this.lblComments.Location = new System.Drawing.Point(8, 172);
			this.lblComments.Name = "lblComments";
			this.lblComments.Size = new System.Drawing.Size(140, 20);
			this.lblComments.TabIndex = 13;
			this.lblComments.Text = "Comments";
			this.lblComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbReason
			// 
			this.cmbReason.AccessibleDescription = "reason for change";
			this.cmbReason.AccessibleName = "reason for change";
			this.cmbReason.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbReason.Enabled = false;
			this.cmbReason.Interval = 500;
			this.cmbReason.Location = new System.Drawing.Point(152, 148);
			this.cmbReason.Name = "cmbReason";
			this.cmbReason.Size = new System.Drawing.Size(230, 22);
			this.cmbReason.TabIndex = 17;
			this.cmbReason.SelectedIndexChanged += new System.EventHandler(this.cmbReason_SelectedIndexChanged);
			// 
			// lblReason
			// 
			this.lblReason.Location = new System.Drawing.Point(8, 148);
			this.lblReason.Name = "lblReason";
			this.lblReason.Size = new System.Drawing.Size(140, 20);
			this.lblReason.TabIndex = 11;
			this.lblReason.Text = "Reason for Change*";
			this.lblReason.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updQuantityAvailable
			// 
			this.updQuantityAvailable.AccessibleDescription = "quantity available";
			this.updQuantityAvailable.AccessibleName = "quantity available";
			this.updQuantityAvailable.Location = new System.Drawing.Point(152, 100);
			this.updQuantityAvailable.Maximum = new System.Decimal(new int[] {
																				 999,
																				 0,
																				 0,
																				 0});
			this.updQuantityAvailable.Name = "updQuantityAvailable";
			this.updQuantityAvailable.Size = new System.Drawing.Size(60, 20);
			this.updQuantityAvailable.TabIndex = 15;
			this.updQuantityAvailable.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updQuantityAvailable.Value = new System.Decimal(new int[] {
																			   0,
																			   0,
																			   0,
																			   0});
			this.updQuantityAvailable.TextChanged += new System.EventHandler(this.QuantityAvailableEvent);
			this.updQuantityAvailable.Leave += new System.EventHandler(this.QuantityAvailableLeaveEvent);
			this.updQuantityAvailable.ValueChanged += new System.EventHandler(this.QuantityAvailableEvent);
			// 
			// lblQuantityAvailable
			// 
			this.lblQuantityAvailable.Location = new System.Drawing.Point(8, 100);
			this.lblQuantityAvailable.Name = "lblQuantityAvailable";
			this.lblQuantityAvailable.Size = new System.Drawing.Size(140, 20);
			this.lblQuantityAvailable.TabIndex = 7;
			this.lblQuantityAvailable.Text = "Quantity Available*";
			this.lblQuantityAvailable.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.AccessibleDescription = "expiration date";
			this.txtExpirationDate.AccessibleName = "expiration date";
			this.txtExpirationDate.Location = new System.Drawing.Point(152, 28);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(160, 20);
			this.txtExpirationDate.TabIndex = 12;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 28);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(140, 20);
			this.lblExpirationDate.TabIndex = 2;
			this.lblExpirationDate.Text = "Expiration Date";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.AccessibleDescription = "lot number";
			this.txtLotNumber.AccessibleName = "lot number";
			this.txtLotNumber.Location = new System.Drawing.Point(152, 4);
			this.txtLotNumber.MaxLength = 50;
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.ReadOnly = true;
			this.txtLotNumber.Size = new System.Drawing.Size(160, 20);
			this.txtLotNumber.TabIndex = 11;
			this.txtLotNumber.Text = "";
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(8, 4);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(140, 20);
			this.lblLotNumber.TabIndex = 0;
			this.lblLotNumber.Text = "Lot Number";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlSupplyName
			// 
			this.pnlSupplyName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSupplyName.Controls.Add(this.txtManufacturer);
			this.pnlSupplyName.Controls.Add(this.lblManufacturer);
			this.pnlSupplyName.Controls.Add(this.txtSupplyName);
			this.pnlSupplyName.Controls.Add(this.lblSupplyName);
			this.pnlSupplyName.Location = new System.Drawing.Point(0, 56);
			this.pnlSupplyName.Name = "pnlSupplyName";
			this.pnlSupplyName.Size = new System.Drawing.Size(390, 48);
			this.pnlSupplyName.TabIndex = 7;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.AccessibleDescription = "manufacturer";
			this.txtManufacturer.AccessibleName = "manufacturer";
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(152, 28);
			this.txtManufacturer.MaxLength = 50;
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(230, 20);
			this.txtManufacturer.TabIndex = 9;
			this.txtManufacturer.Text = "";
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(8, 28);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(140, 20);
			this.lblManufacturer.TabIndex = 2;
			this.lblManufacturer.Text = "Manufacturer";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSupplyName
			// 
			this.txtSupplyName.AccessibleDescription = "manufacturer supply name";
			this.txtSupplyName.AccessibleName = "manufacturer supply name";
			this.txtSupplyName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSupplyName.Location = new System.Drawing.Point(152, 4);
			this.txtSupplyName.MaxLength = 50;
			this.txtSupplyName.Name = "txtSupplyName";
			this.txtSupplyName.ReadOnly = true;
			this.txtSupplyName.Size = new System.Drawing.Size(230, 20);
			this.txtSupplyName.TabIndex = 8;
			this.txtSupplyName.Text = "";
			// 
			// lblSupplyName
			// 
			this.lblSupplyName.Location = new System.Drawing.Point(8, 4);
			this.lblSupplyName.Name = "lblSupplyName";
			this.lblSupplyName.Size = new System.Drawing.Size(152, 20);
			this.lblSupplyName.TabIndex = 0;
			this.lblSupplyName.Text = "Manufacturer Supply Name";
			this.lblSupplyName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSupplyType
			// 
			this.txtSupplyType.AccessibleDescription = "supply type";
			this.txtSupplyType.AccessibleName = "supply type";
			this.txtSupplyType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSupplyType.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtSupplyType.Location = new System.Drawing.Point(152, 36);
			this.txtSupplyType.MaxLength = 75;
			this.txtSupplyType.Name = "txtSupplyType";
			this.txtSupplyType.ReadOnly = true;
			this.txtSupplyType.Size = new System.Drawing.Size(230, 20);
			this.txtSupplyType.TabIndex = 6;
			this.txtSupplyType.Text = "";
			// 
			// lblReagentType
			// 
			this.lblReagentType.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblReagentType.Location = new System.Drawing.Point(8, 36);
			this.lblReagentType.Name = "lblReagentType";
			this.lblReagentType.Size = new System.Drawing.Size(140, 20);
			this.lblReagentType.TabIndex = 1;
			this.lblReagentType.Text = "Supply Type";
			this.lblReagentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlReagentHeader
			// 
			this.pnlReagentHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlReagentHeader.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlReagentHeader.Controls.Add(this.lblReagentHeader);
			this.pnlReagentHeader.Controls.Add(this.picFlask);
			this.pnlReagentHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlReagentHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlReagentHeader.Name = "pnlReagentHeader";
			this.pnlReagentHeader.Size = new System.Drawing.Size(391, 24);
			this.pnlReagentHeader.TabIndex = 0;
			// 
			// lblReagentHeader
			// 
			this.lblReagentHeader.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblReagentHeader.Location = new System.Drawing.Point(24, 2);
			this.lblReagentHeader.Name = "lblReagentHeader";
			this.lblReagentHeader.Size = new System.Drawing.Size(124, 18);
			this.lblReagentHeader.TabIndex = 0;
			this.lblReagentHeader.Text = "Selected Supply";
			this.lblReagentHeader.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// picFlask
			// 
			this.picFlask.Image = ((System.Drawing.Image)(resources.GetObject("picFlask.Image")));
			this.picFlask.Location = new System.Drawing.Point(4, 4);
			this.picFlask.Name = "picFlask";
			this.picFlask.Size = new System.Drawing.Size(16, 16);
			this.picFlask.TabIndex = 0;
			this.picFlask.TabStop = false;
			// 
			// splitter1
			// 
			this.splitter1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.splitter1.Location = new System.Drawing.Point(172, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 390);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlTreeView
			// 
			this.pnlTreeView.Controls.Add(this.cbShowExpired);
			this.pnlTreeView.Controls.Add(this.btnPrint);
			this.pnlTreeView.Controls.Add(this.btnSearch);
			this.pnlTreeView.Controls.Add(this.txtLotSearch);
			this.pnlTreeView.Controls.Add(this.lblLotSearch);
			this.pnlTreeView.Controls.Add(this.tvInventory);
			this.pnlTreeView.Controls.Add(this.pnlTreeViewHeader);
			this.pnlTreeView.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlTreeView.Location = new System.Drawing.Point(0, 0);
			this.pnlTreeView.Name = "pnlTreeView";
			this.pnlTreeView.Size = new System.Drawing.Size(172, 390);
			this.pnlTreeView.TabIndex = 0;
			// 
			// cbShowExpired
			// 
            this.cbShowExpired.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cbShowExpired.AccessibleDescription = "include expired supplies";
			this.cbShowExpired.AccessibleName = "include expired supplies";
			this.cbShowExpired.Location = new System.Drawing.Point(4, 344);
			this.cbShowExpired.Name = "cbShowExpired";
			this.cbShowExpired.Size = new System.Drawing.Size(168, 16);
			this.cbShowExpired.TabIndex = 3;
			this.cbShowExpired.Text = "&Include Expired Supplies";
			this.cbShowExpired.CheckedChanged += new System.EventHandler(this.cbShowExpired_CheckedChanged);
			// 
			// btnPrint
			// 
			this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
			this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnPrint.Location = new System.Drawing.Point(4, 366);
			this.btnPrint.Name = "btnPrint";
			this.btnPrint.Size = new System.Drawing.Size(168, 23);
			this.btnPrint.TabIndex = 4;
			this.btnPrint.Text = "Print Supply Inventory";
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			// 
			// btnSearch
			// 
			this.btnSearch.AccessibleDescription = "search";
			this.btnSearch.AccessibleName = "search";
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Enabled = false;
			this.btnSearch.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(152, 24);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(20, 20);
			this.btnSearch.TabIndex = 4;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtLotSearch
			// 
			this.txtLotSearch.AccessibleDescription = "lot number";
			this.txtLotSearch.AccessibleName = "lot number";
			this.txtLotSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtLotSearch.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtLotSearch.Location = new System.Drawing.Point(32, 24);
			this.txtLotSearch.MaxLength = 50;
			this.txtLotSearch.Name = "txtLotSearch";
			this.txtLotSearch.Size = new System.Drawing.Size(120, 20);
			this.txtLotSearch.TabIndex = 1;
			this.txtLotSearch.Text = "";
			this.txtLotSearch.TextChanged += new System.EventHandler(this.txtLotSearch_TextChanged);
			// 
			// lblLotSearch
			// 
			this.lblLotSearch.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblLotSearch.Location = new System.Drawing.Point(0, 24);
			this.lblLotSearch.Name = "lblLotSearch";
			this.lblLotSearch.Size = new System.Drawing.Size(32, 20);
			this.lblLotSearch.TabIndex = 2;
			this.lblLotSearch.Text = "Lot #";
			this.lblLotSearch.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tvInventory
			// 
			this.tvInventory.AccessibleDescription = "Supply inventory";
			this.tvInventory.AccessibleName = "Supply inventory";
			this.tvInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tvInventory.HideSelection = false;
			this.tvInventory.ImageList = this.imageList1;
			this.tvInventory.Location = new System.Drawing.Point(0, 44);
			this.tvInventory.Name = "tvInventory";
			this.tvInventory.Nodes.AddRange(new System.Windows.Forms.TreeNode[] {
																					new System.Windows.Forms.TreeNode("Supply Type 1", 0, 0, new System.Windows.Forms.TreeNode[] {
																																													 new System.Windows.Forms.TreeNode("Supply Name 1", 1, 1, new System.Windows.Forms.TreeNode[] {
																																																																					  new System.Windows.Forms.TreeNode("Lot Number 1", 2, 2),
																																																																					  new System.Windows.Forms.TreeNode("Lot Number 2", 2, 2)}),
																																													 new System.Windows.Forms.TreeNode("Supply Name 2", 1, 1)}),
																					new System.Windows.Forms.TreeNode("Supply Type 2", 0, 0)});
			this.tvInventory.Size = new System.Drawing.Size(172, 298);
			this.tvInventory.TabIndex = 2;
			this.tvInventory.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvInventory_AfterSelect);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// pnlTreeViewHeader
			// 
			this.pnlTreeViewHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlTreeViewHeader.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlTreeViewHeader.Controls.Add(this.lblInventory);
			this.pnlTreeViewHeader.Controls.Add(this.picInventory);
			this.pnlTreeViewHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlTreeViewHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlTreeViewHeader.Name = "pnlTreeViewHeader";
			this.pnlTreeViewHeader.Size = new System.Drawing.Size(172, 24);
			this.pnlTreeViewHeader.TabIndex = 1;
			// 
			// lblInventory
			// 
			this.lblInventory.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblInventory.Location = new System.Drawing.Point(24, 2);
			this.lblInventory.Name = "lblInventory";
			this.lblInventory.Size = new System.Drawing.Size(124, 18);
			this.lblInventory.TabIndex = 0;
			this.lblInventory.Text = "Inventory";
			this.lblInventory.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// picInventory
			// 
			this.picInventory.Image = ((System.Drawing.Image)(resources.GetObject("picInventory.Image")));
			this.picInventory.Location = new System.Drawing.Point(4, 4);
			this.picInventory.Name = "picInventory";
			this.picInventory.Size = new System.Drawing.Size(16, 16);
			this.picInventory.TabIndex = 0;
			this.picInventory.TabStop = false;
			// 
			// grpImage1
			// 
			this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage1.Controls.Add(this.pictureBox2);
			this.grpImage1.Location = new System.Drawing.Point(4, 32);
			this.grpImage1.Name = "grpImage1";
			this.grpImage1.Size = new System.Drawing.Size(48, 412);
			this.grpImage1.TabIndex = 0;
			this.grpImage1.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 12);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(40, 44);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox2.TabIndex = 1;
			this.pictureBox2.TabStop = false;
			// 
			// FrmRecordSupplyUsage
			// 
			this.AcceptButton = this.btnUpdate;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(642, 473);
			this.Controls.Add(this.grpImage1);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpInventory);
			this.hlphelpChm.SetHelpKeyword(this, "Update_Supply_Inventory_.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Name = "FrmRecordSupplyUsage";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Update Supplies";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmRecordSupplyUsage_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpInventory, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage1, 0);
			this.grpInventory.ResumeLayout(false);
			this.pnlContainer.ResumeLayout(false);
			this.pnlSupplyType.ResumeLayout(false);
			this.pnlLot.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updQuantityAvailable)).EndInit();
			this.pnlSupplyName.ResumeLayout(false);
			this.pnlReagentHeader.ResumeLayout(false);
			this.pnlTreeView.ResumeLayout(false);
			this.pnlTreeViewHeader.ResumeLayout(false);
			this.grpImage1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get Comment
		/// </summary>
		public string Comment
		{
			get
			{
				string comment = "";
				if (this.cmbReason.SelectedIndex>-1)
				{
					if (this.cmbReason.Text.Trim().ToUpper() != "OTHER")
					{
						comment	= this.cmbReason.Text;
					}
					if (this.txtComments.Text.Trim().Length>0)
					{
						if ((comment.Length>0) && (comment[comment.Length-1] != '.'))
						{
							comment = comment + ". ";
						}
						comment = comment + this.txtComments.Text;
					}
				}
				return comment;
			}
		}

		private void SearchTreeViewForLotNumber(string lotNumber)
		{
			bool foundIt = false;

			foreach (TreeNode typeNode in this.tvInventory.Nodes)
			{
				foreach(TreeNode nameNode in typeNode.Nodes)
				{
					foreach(TreeNode lotNode in nameNode.Nodes)
					{
						if (lotNode.Text.IndexOf(lotNumber) == 0)
						{
							this.tvInventory.SelectedNode = lotNode;
							foundIt = true;
							return;
						}
					}
				}
			}

			//Eventually, need to use foundIt to do a partial search????
			if (!foundIt)
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC081.LotNumberNotFound(lotNumber));
		}

		private void SetLotNumberNode()
		{
			if (this._selectedSupply.LotExpirationDate < BOL.VBECSDateTime.GetDivisionCurrentDateTime())
			{
				this.cbShowExpired.Checked = true;
			}
			//
			foreach (TreeNode typeNode in this.tvInventory.Nodes)
			{
				if (typeNode.Text == this._selectedSupply.SupplyTypeText)
				{
					foreach(TreeNode nameNode in typeNode.Nodes)
					{
						if (nameNode.Text == this._selectedSupply.SupplyName)
						{
							foreach(TreeNode lotNode in nameNode.Nodes)
							{
								if (lotNode.Text == this._selectedSupply.LotNumber)
								{
									this.tvInventory.SelectedNode = lotNode;
									break;
								}
							}
						}
					}
				}
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC081.FrmRecordSupplyUsage());
			//
			this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			this.ttToolTip.SetToolTip(this.btnPrint, Common.StrRes.Tooltips.Common.Print().ResString);
			this.ttToolTip.SetToolTip(this.btnSearch, Common.StrRes.Tooltips.UC081.SearchForLotNumber().ResString);
			//
			this.dtpChangedTime.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpChangedTime.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			this.tvInventory.PathSeparator = "\t";
			this.LoadInventoryTreeView();
			this.PopulateReasonComboBox();
		}

		private void txtLotSearch_TextChanged(object sender, System.EventArgs e)
		{
			this.btnSearch.Enabled = (this.txtLotSearch.Text.Length > 0);
		}

		/// <summary>
		/// Fills the canned comments with values
		/// </summary>
		private void PopulateReasonComboBox()
		{
			System.Data.DataTable dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode, "RS");

			foreach(System.Data.DataRow dr in dtComments.Rows)
			{
				this.cmbReason.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}
		}

		/// <summary>
		/// Loads TreeView with Supplies
		/// </summary>
		private void LoadInventoryTreeView()
		{
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			bool isExpired = false;

			string limitingInvoice = (this._limitInvoice) ? this._selectedSupply.InvoiceNumber : string.Empty;

			this.tvInventory.Nodes.Clear();
			
			//This will return all supplies for our division
			System.Collections.ArrayList alSupplies = BOL.Supply.GetSupplyList(Common.SupplyType.AllSupplies, true, limitingInvoice);
			
			for (int ndx=0; ndx < alSupplies.Count; ndx++)
			{
				BOL.Supply tmpSupply = (BOL.Supply)alSupplies[ndx];

				isExpired = (tmpSupply.LotExpirationDate < currentDate);

				//Don't display if expired and the Show Expired checkbox is unchecked
				if (isExpired && (!this.cbShowExpired.Checked))
				{
					continue;
				}
				
				TreeNode parentNode = AddSupplyTypeNode(tmpSupply);

				TreeNode childNode = AddSupplyNameNode(parentNode, tmpSupply);

				TreeNode lotNode = AddLotNumberNode(childNode, tmpSupply, isExpired);

			}

		}

		/// <summary>
		/// AddSupplyTypeNode
		/// </summary>
		/// <param name="supply"></param>
		private TreeNode AddSupplyTypeNode(BOL.Supply supply)
		{			
			TreeNode supplyTypeNode = new TreeNode(supply.SupplyTypeText,0,0);
			
			foreach(TreeNode searchNode in this.tvInventory.Nodes)
			{
				if (searchNode.Text == supply.SupplyTypeText)
				{
					return(searchNode);
				}
			}

			this.tvInventory.Nodes.Add(supplyTypeNode);
			return(supplyTypeNode);
		}

		/// <summary>
		/// AddSupplyNameNode
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="supply"></param>
		private TreeNode AddSupplyNameNode(TreeNode parentNode, BOL.Supply supply)
		{
			TreeNode supplyNameNode = new TreeNode(supply.SupplyName,1,1);

			foreach(TreeNode searchNode in parentNode.Nodes)
			{
				if (searchNode.Text == supply.SupplyName)
				{
					return(searchNode);
				}
			}

			parentNode.Nodes.Add(supplyNameNode);
			return(supplyNameNode);
		}

		/// <summary>
		/// AddLotNumberNode
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="supply"></param>
		/// <param name="isExpired">is expired</param>
		private TreeNode AddLotNumberNode(TreeNode parentNode, BOL.Supply supply, bool isExpired)
		{
			TreeNode lotNode = new TreeNode(supply.LotNumber,2,2);
			lotNode.Tag = supply.SupplyGuid;

			if (isExpired)
				lotNode.ForeColor = Color.FromKnownColor(KnownColor.GrayText);

			parentNode.Nodes.Add(lotNode);
			return(lotNode);
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			DlgSupplyInventoryCriteria dlgPrintCriteria = new DlgSupplyInventoryCriteria();

            dlgPrintCriteria.ShowDialogFromLockedParent(this, false);
			if (dlgPrintCriteria.DialogResult != DialogResult.OK)
			{
				dlgPrintCriteria.Dispose();
				return;
			}
			
			FrmSupplyInventory dlgPrintInventory = new FrmSupplyInventory(dlgPrintCriteria.SupplyInventoryReport, dlgPrintCriteria.SupplyInventoryReportData);
            dlgPrintInventory.ShowDialogFromLockedParent(this, false);
			dlgPrintInventory.Dispose();
		}

		private void tvInventory_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if (!this._isLoading)
			{
				int level = GetSelectedLevel(this.tvInventory.SelectedNode);

				//If the level is less than 2, it's a SupplyType, SupplyName -- Clear and Leave
				if (level < 2)
				{
					this.SetControlData(false, level);
					this.SetControlState(false,level);
					return;
				}

				this._selectedSupply = null;
				System.Guid supplyGuid = (System.Guid)this.tvInventory.SelectedNode.Tag;

				if (this.SetLocks(supplyGuid))
				{
					this._selectedSupply = new BOL.Supply(supplyGuid);
					this.AttachEvents();

					//Display --- 
					this.SetControlData(false,level);
					this.SetControlState(true, level);
				}
				else
				{
					this.tvInventory.SelectedNode = this.tvInventory.SelectedNode.Parent;
				}
			}
		}

		private void AttachEvents()
		{
			this._selectedSupply.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmRecordSupplyUsage.RuleSets.UpdateSupply);

			this._selectedSupply.IsDirtyChanged += new EventHandler(this.ObjectChanging);
			this._selectedSupply.Valid += new EventHandler(this.ObjectChanging);
			this._selectedSupply.Invalid += new EventHandler(this.ObjectChanging);
		}

		/// <summary>
		/// Fires when the object is changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ObjectChanging(object sender, EventArgs e)
		{
			if (this._selectedSupply.BrokenRulesCount == 0)
			{
				this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			else
			{
				this.btnUpdate.SetToolTip(this._selectedSupply.GetBrokenRulesMessage(this.Name));
			}
			this.btnUpdate.EnabledButton = (this._selectedSupply.BrokenRulesCount == 0);	
		}

		/// <summary>
		/// Sets the data on the form
		/// </summary>
		/// <param name="blankFields"></param>
		/// <param name="level">level</param>
		private void SetControlData(bool blankFields, int level)
		{
			this._isLoading = true;

			if (blankFields)
			{
				this.txtSupplyType.Text = string.Empty;
				this.txtSupplyName.Text = string.Empty;
				this.txtManufacturer.Text = string.Empty;
				this.txtLotNumber.Text = string.Empty;
				this.txtExpirationDate.Text = string.Empty;
				this.rdoSatisfactory.Checked = false;
				this.rdoUnsatisfactory.Checked = false;
				//Setting both of these to unchecked will result in 
				//the radio buttons losing their tabstop value
				//don't ask me why, ask microsoft.
				this.rdoSatisfactory.TabStop = true;
				this.updQuantityAvailable.Value = 0;
				this.errError.SetVbecsError(updQuantityAvailable, string.Empty); // **** 508 Compliance ***
				this.dtpChangedTime.Value = this.dtpChangedTime.MaxDate;
				this.cmbReason.SelectedIndex = -1;
				this.txtComments.Text = string.Empty;
				this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
			else
			{
				if (level == 0)
				{
					this.txtSupplyType.Text = this.tvInventory.SelectedNode.Text;
				}
				if (level == 1)
				{
					this.txtSupplyType.Text = this.tvInventory.SelectedNode.Parent.Text;
					this.txtSupplyName.Text = this.tvInventory.SelectedNode.Text;
				}
				if (level == 2)
				{	
					this.txtSupplyType.Text = this._selectedSupply.SupplyTypeText;
					this.txtSupplyName.Text = this._selectedSupply.SupplyName;
					this.txtManufacturer.Text = this._selectedSupply.ManufacturerName;
					this.txtLotNumber.Text = this._selectedSupply.LotNumber;
					this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._selectedSupply.LotExpirationDate);
					this.rdoSatisfactory.Checked = (this._selectedSupply.SatisfactoryIndicator) ? true : false;
					this.rdoUnsatisfactory.Checked = (this._selectedSupply.SatisfactoryIndicator) ? false : true;
					try
					{
						//Make sure the user can't select anything over the initial quantity
						this.updQuantityAvailable.Maximum = this._selectedSupply.LotQuantity;
						this.updQuantityAvailable.Value = this._selectedSupply.AvailableQuantity;
						this.errError.SetVbecsError(updQuantityAvailable, string.Empty); // **** 508 Compliance ***
					}
					catch(FormatException)
					{
						this.updQuantityAvailable.Value = this.updQuantityAvailable.Minimum;
					}
					
					//We set this field automatically, so it has a default value in the object
					this.dtpChangedTime.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					this._selectedSupply.InventoryChangeDate = this.dtpChangedTime.MaxDate;

					this.cmbReason.SelectedIndex = -1;
					this.txtComments.Text = string.Empty;
				}
			}
			this._isLoading = false;
		}

		/// <summary>
		/// Sets the controls enabled property on the form
		/// </summary>
		/// <param name="enableFields"></param>
		/// <param name="level"></param>
		private void SetControlState(bool enableFields, int level)
		{
			this.pnlSupplyName.Visible = (level > 0);
			this.pnlLot.Visible = (level > 1);

			//Keep these hidden until a change is made
			this.txtComments.Visible = false;
			this.dtpChangedTime.Visible = false;
			this.cmbReason.Visible = false;
			this.lblComments.Visible = false;
			this.lblDateTime.Visible = false;
			this.lblReason.Visible = false;

			this.updQuantityAvailable.Enabled = enableFields;
			this.dtpChangedTime.Enabled = enableFields;
			this.cmbReason.Enabled = enableFields;
			if (this.cmbReason.Text == "Other" && enableFields)
			{
				this.lblComments.Text = "Comments*";
			}
			else
			{
				this.lblComments.Text = "Comments";
			}
			this.txtComments.Enabled = enableFields;

			this.btnUpdate.EnabledButton = false;
		}

		/// <summary>
		/// GetSelectedLevel
		/// </summary>
		/// <param name="e"></param>
		/// <returns></returns>
		private int GetSelectedLevel(TreeNode e)
		{
			if (this.tvInventory.Nodes.Count==0)
			{
				return -1;
			}
			string str = e.FullPath;
			string strcmp = this.tvInventory.PathSeparator;
			int pos = 0;
			int level = 0;
			while (str.IndexOf(strcmp,pos) > -1)
			{
				pos = str.IndexOf(strcmp,pos)+1;
				level = level +1;
			}
			return level;
		}

		private void cbShowExpired_CheckedChanged(object sender, System.EventArgs e)
		{
			this._isLoading = true;
			this.LoadInventoryTreeView();
			this._isLoading = false;
		}

		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			try
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("supply")) == DialogResult.Yes)
				{
					if (this._selectedSupply.Update(Common.UpdateFunction.UC081_FrmRecordSupplyUsage))
					{
						//CR 1441
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.UpdateSupplyInventory);
						if(dt!= null)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}
						//Save this off, so we can refresh the data
						System.Guid refreshGuid = this._selectedSupply.SupplyGuid;

						//It was a success, so unluck the object
						this.UnlockAllRecords();
						this._selectedSupply = null;

						if (this._limitInvoice)
						{
							this.DialogResult = DialogResult.OK;
							this.Close();
						}
						else
						{
							this._selectedSupply = new BOL.Supply(refreshGuid);

							//Should up the node, and reload the data as part of tv_AfterSelect
							this.tvInventory.SelectedNode = this.tvInventory.SelectedNode.Parent;
						}
						//this.SetControlData(false, 1);
						//this.SetControlState(false,1);
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Supply"));
					}
				}
			}
			catch (Common.RowVersionException)
			{
				this.btnUpdate.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
		}

		private void cmbReason_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading && this.cmbReason.SelectedIndex != -1)
			{
				this._selectedSupply.Comments = this.Comment;//this.cmbReason.Text;
				//this.txtComments.Enabled = (this.cmbReason.Text == "Other");
				if (this.cmbReason.Text.ToUpper() == "OTHER")
				{
					this.lblComments.Text = "Comments*";
				}
				else
				{
					this.lblComments.Text = "Comments";
				}
			}
		}

		private void txtComments_Leave(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				this._selectedSupply.Comments = this.Comment;//this.cmbReason.Text + " " + this.txtComments.Text;
			}
		}

		private void InventoryChangeDateEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._selectedSupply.InventoryChangeDate = this.dtpChangedTime.Value;
			}
		}

		private void QuantityAvailableEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this._selectedSupply.AvailableQuantity = System.Convert.ToInt32(this.updQuantityAvailable.Value);
					this.txtComments.Visible = true;
					this.cmbReason.Visible = true;
					this.dtpChangedTime.Visible = true;
					this.lblComments.Visible = true;
					this.lblDateTime.Visible = true;
					this.lblReason.Visible = true;
					this.errError.SetVbecsError(updQuantityAvailable, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					this._selectedSupply.AvailableQuantity = int.MinValue;
				}
			}
		}

		private void QuantityAvailableLeaveEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this._selectedSupply.AvailableQuantity = System.Convert.ToInt32(this.updQuantityAvailable.Value);
					this.txtComments.Visible = true;
					this.cmbReason.Visible = true;
					this.dtpChangedTime.Visible = true;
					this.lblComments.Visible = true;
					this.lblDateTime.Visible = true;
					this.lblReason.Visible = true;
					this.errError.SetVbecsError(updQuantityAvailable, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					this._selectedSupply.AvailableQuantity = int.MinValue;
					this.errError.SetVbecsError(updQuantityAvailable, err.Message); // **** 508 Compliance ***
				}
			}
		}

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.SearchTreeViewForLotNumber(this.txtLotSearch.Text.Trim());
		}

		private void dtpChangedTime_Enter(object sender, System.EventArgs e)
		{
			this.dtpChangedTime.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmRecordSupplyUsage_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnUpdate.EnabledButton )
			{
				textToSpeak = this.btnUpdate.GetToolTip();
			}
			//
			if ( textToSpeak.Length > 0 )
			{
				this.SpeakMessage( textToSpeak );
			}
		}
	}
}

